/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.plant;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.utils.Array;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.rendering.utils.ColorMixer;

public class PlantEntityAttributes
implements EntityAttributes {
    private final long seed;
    private PlantSpecies species;
    private int currentTileHeight;
    private Color actualBranchColor;
    private Color actualLeafColor;
    private Color actualFruitColor;
    private float leafColorChangeAmount;
    private float leafColorChangeRate = 1.0f;
    private float leafDropAmount = 1.0f;
    private FruitState fruitState = null;
    private float fruitStateProgress = 0.0f;
    private float growthRate = 1.0f;
    private float growthAmount = 0.9f;
    private boolean fullyGrown = false;

    @Override
    public EntityAttributes clone() {
        PlantEntityAttributes cloned = new PlantEntityAttributes(this.seed);
        cloned.species = this.species;
        cloned.currentTileHeight = this.currentTileHeight;
        cloned.actualBranchColor = this.actualBranchColor.cpy();
        cloned.actualLeafColor = this.actualLeafColor.cpy();
        cloned.actualFruitColor = this.actualFruitColor.cpy();
        cloned.leafColorChangeAmount = this.leafColorChangeAmount;
        cloned.leafColorChangeRate = this.leafColorChangeRate;
        cloned.leafDropAmount = this.leafDropAmount;
        cloned.fruitState = this.fruitState;
        cloned.fruitStateProgress = this.fruitStateProgress;
        cloned.growthRate = this.growthRate;
        cloned.growthAmount = this.growthAmount;
        cloned.fullyGrown = this.fullyGrown;
        return cloned;
    }

    public float getGrowthAmount() {
        return this.growthAmount;
    }

    public void setGrowthAmount(float growthAmount) {
        this.growthAmount = growthAmount;
    }

    public PlantEntityAttributes(long seed) {
        this.seed = seed;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public Color getColor(ColoringLayer coloringLayer) {
        switch (coloringLayer) {
            case LEAF_COLOR: {
                return this.actualLeafColor;
            }
            case BRANCHES_COLOR: {
                return this.actualBranchColor;
            }
            case FRUIT_COLOR: {
                return this.actualFruitColor;
            }
        }
        return null;
    }

    private void updateColors() {
        if (this.species != null) {
            if (this.leafColorChangeAmount <= 0.0f) {
                this.actualLeafColor = this.species.randomLeafColor(new RandomXS128(this.seed));
                this.actualBranchColor = this.species.randomBranchColor(new RandomXS128(this.seed));
            } else {
                Color oldColor = this.actualLeafColor;
                Array<Color> newColors = new Array<Color>();
                Array<Array<Color>> leafTransitionColors = this.species.getLeafTransitionColors();
                for (Array<Color> colorSwatch : leafTransitionColors) {
                    Array<Color> colorSwatchWithLeafColor = new Array<Color>();
                    colorSwatchWithLeafColor.add(this.species.randomLeafColor(new RandomXS128(this.seed)));
                    colorSwatchWithLeafColor.addAll(colorSwatch);
                    float transitionTarget = this.leafColorChangeAmount * (float)colorSwatchWithLeafColor.size;
                    Color leftColor = ((Color)colorSwatchWithLeafColor.get((int)Math.floor(transitionTarget))).cpy();
                    Color rightColor = ((Color)colorSwatchWithLeafColor.get(Math.min((int)Math.ceil(transitionTarget), colorSwatchWithLeafColor.size - 1))).cpy();
                    float rightAmount = (float)((double)transitionTarget - Math.floor(transitionTarget));
                    float leftAmount = (float)Math.ceil(transitionTarget) - transitionTarget;
                    leftColor.mul(leftAmount);
                    rightColor.mul(rightAmount);
                    Color finalColor = leftColor.add(rightColor);
                    finalColor.a = 1.0f;
                    newColors.add(finalColor);
                }
                Color newColor = ColorMixer.randomBlend(new RandomXS128(this.seed), newColors);
                this.actualLeafColor = ColorMixer.average(oldColor, newColor);
            }
            if (this.species.getFruit() != null) {
                this.actualFruitColor = this.species.getFruit().getColor().cpy();
            }
        }
    }

    public boolean isFullyGrown() {
        return this.fullyGrown;
    }

    public void setFullyGrown(boolean fullyGrown) {
        this.fullyGrown = fullyGrown;
    }

    public float getGrowthRate() {
        return this.growthRate;
    }

    public void setGrowthRate(float growthRate) {
        this.growthRate = growthRate;
    }

    public boolean showLeaves() {
        return this.leafColorChangeAmount < 0.0f;
    }

    public PlantSpecies getSpecies() {
        return this.species;
    }

    public void setSpecies(PlantSpecies species) {
        this.species = species;
        this.updateColors();
    }

    public int getCurrentTileHeight() {
        return this.currentTileHeight;
    }

    public void setCurrentTileHeight(int currentTileHeight) {
        this.currentTileHeight = currentTileHeight;
    }

    public void setLeafColorChangeAmount(float leafColorChangeAmount) {
        this.leafColorChangeAmount = leafColorChangeAmount;
        this.updateColors();
    }

    public FruitState getFruitState() {
        return this.fruitState;
    }

    public float getFruitGrowthAmount() {
        return this.fruitStateProgress;
    }

    public void setFruitState(FruitState fruitState) {
        this.fruitState = fruitState;
    }

    public void setFruitStateProgress(float fruitStateProgress) {
        this.fruitStateProgress = fruitStateProgress;
    }

    public Color getActualFruitColor() {
        return this.actualFruitColor;
    }

    public void setActualFruitColor(Color actualFruitColor) {
        this.actualFruitColor = actualFruitColor;
    }

    public Color getActualBranchColor() {
        return this.actualBranchColor;
    }

    public Color getActualLeafColor() {
        return this.actualLeafColor;
    }

    public void setActualBranchColor(Color actualBranchColor) {
        this.actualBranchColor = actualBranchColor;
    }

    public void setActualLeafColor(Color actualLeafColor) {
        this.actualLeafColor = actualLeafColor;
    }

    public float getLeafColorChangeAmount() {
        return this.leafColorChangeAmount;
    }

    public float getLeafColorChangeRate() {
        return this.leafColorChangeRate;
    }

    public void setLeafColorChangeRate(float leafColorChangeRate) {
        this.leafColorChangeRate = leafColorChangeRate;
    }

    public float getLeafDropAmount() {
        return this.leafDropAmount;
    }

    public void setLeafDropAmount(float leafDropAmount) {
        this.leafDropAmount = leafDropAmount;
    }

    public static enum FruitState {
        BARE,
        BUDDING,
        RIPENING,
        RIPE;

        private FruitState next;

        public FruitState getNext() {
            return this.next;
        }

        static {
            FruitState.BARE.next = BUDDING;
            FruitState.BUDDING.next = RIPENING;
            FruitState.RIPENING.next = RIPE;
            FruitState.RIPE.next = BARE;
        }
    }
}

